import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { memo } from "react";
import { useBreakpoint } from "../context/breakpoints.mjs";
import { useTldrawUiComponents } from "../context/components.mjs";
const DefaultMenuPanel = memo(function MenuPanel() {
  const breakpoint = useBreakpoint();
  const { MainMenu, QuickActions, ActionsMenu, PageMenu } = useTldrawUiComponents();
  if (!MainMenu && !PageMenu && breakpoint < 6) return null;
  return /* @__PURE__ */ jsx("div", { className: "tlui-menu-zone", children: /* @__PURE__ */ jsxs("div", { className: "tlui-buttons__horizontal", children: [
    MainMenu && /* @__PURE__ */ jsx(MainMenu, {}),
    PageMenu && /* @__PURE__ */ jsx(PageMenu, {}),
    breakpoint < 6 ? null : /* @__PURE__ */ jsxs(Fragment, { children: [
      QuickActions && /* @__PURE__ */ jsx(QuickActions, {}),
      ActionsMenu && /* @__PURE__ */ jsx(ActionsMenu, {})
    ] })
  ] }) });
});
export {
  DefaultMenuPanel
};
//# sourceMappingURL=DefaultMenuPanel.mjs.map
